/*
 * Decompiled with CFR 0.152.
 */
package com.endilcrafter.farmersplus.data;

import com.endilcrafter.farmersplus.common.registry.PlusBlocks;
import com.endilcrafter.farmersplus.common.registry.PlusItems;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.data.ItemModels;

public class PlusItemModels
extends ItemModelProvider {
    public PlusItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "farmersplus", existingFileHelper);
    }

    protected void registerModels() {
        Set items = ForgeRegistries.ITEMS.getValues().stream().filter(i -> "farmersplus".equals(ForgeRegistries.ITEMS.getKey(i).m_135827_())).collect(Collectors.toSet());
        items.remove(PlusItems.EGG_BOX.get());
        items.remove(PlusItems.CANVAS_CHEST.get());
        items.remove(PlusItems.TERRACOTTA_POT.get());
        items.remove(PlusItems.GRATIN_BLOCK.get());
        this.spriteModel(PlusBlocks.EGG_BOX);
        this.spriteModel(PlusBlocks.TERRACOTTA_POT);
        this.spriteModel(PlusBlocks.GRATIN_BLOCK);
        ItemModels.takeAll(items, i -> i instanceof BlockItem).forEach(item -> this.blockBasedModel((Item)item, ""));
        for (RegistryObject itemRegistryObject : Arrays.asList(PlusItems.BREAD_CRUMB, PlusItems.RICE_FLOUR, PlusItems.WHEAT_FLOUR, PlusItems.LARD_BOTTLE, PlusItems.LARD_BUCKET, PlusItems.TERRACOTTA_BOWL, PlusItems.BEEF_TONGUE, PlusItems.BEEF_TONGUE_SKIN, PlusItems.SKINNED_BEEF_TONGUE, PlusItems.BEEF_TONGUE_SLICE, PlusItems.COOKED_BEEF_TONGUE, PlusItems.COOKED_BEEF_TONGUE_SLICE, PlusItems.APPLE_SLICE, PlusItems.GOLDEN_APPLE_SLICE, PlusItems.DRIED_APPLE_SLICE, PlusItems.DRIED_GOLDEN_APPLE_SLICE, PlusItems.DRIED_BEEF, PlusItems.DRIED_CHICKEN, PlusItems.DRIED_COD_SLICE, PlusItems.DRIED_MUTTON, PlusItems.DRIED_PORKCHOP, PlusItems.DRIED_RABBIT, PlusItems.DRIED_SALMON_SLICE, PlusItems.DRIED_BEEF_TONGUE_SKIN, PlusItems.BOILED_EGG, PlusItems.MINCED_CHICKEN, PlusItems.MINCED_PORK, PlusItems.COOKED_MINCED_CHICKEN, PlusItems.PORK_PATTY, PlusItems.CHICKEN_NUGGET, PlusItems.KOROKKE, PlusItems.FRIED_HOLY_BASIL, PlusItems.SALISBURY_STEAK, PlusItems.GRATIN)) {
            this.simpleModel((RegistryObject<Item>)itemRegistryObject);
        }
        this.mugModel(PlusItems.TOMATO_JUICE);
    }

    private ItemModelBuilder simpleModel(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("farmersplus", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder handheldModel(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("farmersplus", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder spriteModel(RegistryObject<Block> block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(block.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("farmersplus", "item/" + block.getId().m_135815_()));
    }

    private ItemModelBuilder plantModel(RegistryObject<Block> plant) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(plant.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("farmersplus", "block/" + plant.getId().m_135815_()));
    }

    private ItemModelBuilder mugModel(RegistryObject<Item> mug) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName((Item)mug.get()), new ResourceLocation("farmersplus", "item/mug"))).texture("layer0", new ResourceLocation("farmersplus", "item/" + mug.getId().m_135815_()));
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(this.itemName(item), this.resourceBlock(this.itemName(item) + suffix));
    }

    private String itemName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("farmersplus", "block/" + path);
    }

    public ResourceLocation resourceItem(String path) {
        return new ResourceLocation("farmersplus", "item/" + path);
    }
}

